<?php
require __DIR__ . '/config.php';

header('Content-Type: application/json');

if (!isset($_GET['org_id'])) {
    echo json_encode(["success" => false, "message" => "Missing org_id"]);
    exit;
}

$conn = getDbConnection();
$org_id = intval($_GET['org_id']);

$query = "SELECT * FROM sites WHERE org_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $org_id);
$stmt->execute();
$result = $stmt->get_result();

$sites = [];
while ($row = $result->fetch_assoc()) {
    $sites[] = $row;
}

echo json_encode(["success" => true, "sites" => $sites]);

$conn->close();
?>
