<?php
require 'db_config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $user_id = $_POST['user_id'];

    // Get site and organization status
    $stmt = $conn->prepare("
        SELECT s.subscription_status AS site_status, o.subscription_status AS org_status 
        FROM users u
        JOIN sites s ON u.site_id = s.site_id
        JOIN organizations o ON s.org_id = o.org_id
        WHERE u.user_id = ?
    ");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $stmt->bind_result($site_status, $org_status);
    $stmt->fetch();
    $stmt->close();

    if ($org_status === 'Inactive') {
        echo json_encode(["access" => "denied", "reason" => "Organization subscription expired"]);
    } elseif ($site_status === 'Inactive') {
        echo json_encode(["access" => "denied", "reason" => "Site subscription expired"]);
    } else {
        echo json_encode(["access" => "granted"]);
    }
}
$conn->close();
?>
